﻿<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Karta zasiłkowa</title>
		<script runat="server">
		
            public class Total : IComparable {

                public class Item : IComparable {
                    readonly WypElement element;
                    readonly bool zaokres;
                    readonly string symbol;
                    readonly bool wypadek;
                    readonly bool wynagrodzenie;
                    public Item(WypElement element, string symbol, bool wypadek)
                        : this(element, symbol, wypadek, false) {
                    }
                    public Item(WypElement element, string symbol, bool wypadek, bool wynagrodzenie) {
                        this.element = element;
                        this.zaokres = element is WypElementNieobecność || element is WypElementStorno;
                        this.symbol = symbol;
                        this.wypadek = wypadek;
                        this.wynagrodzenie = wynagrodzenie;
                    }
                    public WypElement Element {
                        get { return element; }
                    }
                    public int CompareTo(object obj) {
                        if (obj == null)
                            return 1;
                        Item item = obj as Item;
                        if (item == null)
                            throw new ArgumentException();
                        int i = element.Data.CompareTo(item.Element.Data);
                        if (i == 0)
                            i = OkresOd.CompareTo(item.OkresOd);
                        if (i == 0)
                            i = -OkresDo.CompareTo(item.OkresDo);
                        if (i == 0)
                            i = element.Definicja.Kolejnosc.CompareTo(item.element.Definicja.Kolejnosc);
                        if (i == 0) {
                            bool x = element is WypElementStorno;
                            bool y = item.element is WypElementStorno;
                            if (x != y)
                                i = x ? 1 : -1;
                        }

                        return i;
                    }
                    public Date OkresOd {
                        get { return zaokres ? element.Okres.From : Date.Empty; }
                    }
                    public Date OkresDo {
                        get { return zaokres ? element.Okres.To : Date.Empty; }
                    }
                    public int Dni {
                        get {
                            if (!zaokres)
                                return 0;
                            int days = element.Okres.Days;
                            if (element is WypElementStorno)
                                return -days;
                            return days;
                        }
                    }
                    public decimal ZasiłekDzn {
                        get {
                            if (wynagrodzenie)
                                return 0.00m;
                            return zaokres ? element.Wartosc / Dni : 0;
                        }
                    }
                    public decimal ZasiłekBrutto {
                        get {
                            if (wynagrodzenie)
                                return 0.00m;
                            return element.Wartosc;
                        }
                    }
                    public decimal ZalFIS {
                        get {
                            if (wynagrodzenie)
                                return 0.00m;
                            return element.Podatki.ZalFIS;
                        }
                    }
                    public decimal Netto {
                        get {
                            if (wynagrodzenie)
                                return 0.00m;
                            return element.Wartosc - element.Podatki.ZalFIS;
                        }
                    }
                    public string Rodzaj {
                        get { return symbol + " " + Procent + " " + (wypadek ? "W" : ""); }
                    }
                    public string Symbol {
                        get {
                            WypElementNieobecność en = element as WypElementNieobecność;
                            if (en == null)
                                return "";
                            return en.Nieobecność != null ? en.Nieobecność.Zwolnienie.KodChoroby : "";
                        }
                    }
                    Percent Procent {
                        get {
                            WypSkladnikGłówny skl = Element.SkładnikGłówny;
                            if (skl == null)
                                return Percent.Zero;
                            return Element.SkładnikGłówny.Procent;
                        }
                    }
                    public decimal Podstawa {
                        get {
                            WypSkladnikGłówny skl = Element.SkładnikGłówny;
                            if (skl == null)
                                return 0m;
                            return (decimal)skl.Podstawa1.Value;
                        }
                    }
                    public string Miesiące {        //TID: 8397
                        get {
                            WypElementNieobecność en = Element as WypElementNieobecność;
                            if (en == null)
                                return "";
                            PodstawaZasiłku podstawa = new PodstawaZasiłku(en);
                            podstawa.PrzeliczajPoprzednieRozliczenie = true;
                            decimal p = podstawa.Podstawa;
                            if (podstawa.Podstawa==0) { //Wymuszenie wyliczenia podstawy.
                            }
                            
                            YearMonth pod = podstawa.NaliczanieOd;
                            YearMonth pdo = podstawa.NaliczanieDo;

                            if (pod==pdo)
                                return string.Format("{0} {1}", pdo.Month, pdo.Year);
                            if (pod.Year == pdo.Year)
                                return string.Format("{0}-{1} {2}", pod.Month, pdo.Month, pdo.Year);
                            return string.Format("{0} {1}-{2} {3}", pod.Month, pod.Year, pdo.Month, pdo.Year);
                        }
                    }
                }

                readonly Pracownik pracownik;
                readonly PracHistoria historia;
                readonly ArrayList elementy = new ArrayList();
                public Total(Pracownik pracownik, FromTo okres) {
                    this.pracownik = pracownik;
                    this.historia = pracownik[okres.To];
                    PlaceModule pl = PlaceModule.GetInstance(pracownik);
                    SubTable st = pl.WypElementy.WgPracownik[pracownik];
                    st = new SubTable(st, okres);
                    foreach (WypElement e in st) {
                        try {
                            Wydzial wdz = e.Wyplata.ListaPlac.Wydzial;
                            if (e.Wartosc != 0) {
                                KodRSA kr = e.KodRSA;
                                if (kr != null)
                                    switch (kr.Kod) {
                                        case 211:
                                            elementy.Add(new Item(e, "Pr", false)); break;
                                        case 212:
                                            elementy.Add(new Item(e, "Wr", false)); break;
                                        case 213:
                                            elementy.Add(new Item(e, "Pg", false)); break;
                                        case 311:
                                        case 315:
                                        case 325:
                                            elementy.Add(new Item(e, "UM", false)); break;
                                        case 312:
                                        case 316:
                                            elementy.Add(new Item(e, "OP", false)); break;
                                        case 313:
                                        case 317:
                                            elementy.Add(new Item(e, "Ch", false)); break;
                                        case 314:
                                        case 318:
                                            elementy.Add(new Item(e, "Ch", true)); break;
                                        case 321:
                                        case 323:
                                            elementy.Add(new Item(e, "Reh", false)); break;
                                        case 319:
                                        case 322:
                                        case 324:
                                            elementy.Add(new Item(e, "UR", false)); break;
                                        case 327:
                                            elementy.Add(new Item(e, "UO", false)); break;	
                                        case 331:
                                        case 332:
                                        case 335:
                                        case 336:
                                            elementy.Add(new Item(e, "WCh", false, true)); break;
                                        case 333:
                                        case 334:
                                        case 337:
                                        case 338:
                                            elementy.Add(new Item(e, "WCh", true, true)); break;
                                    }
                            }
                        }
                        catch { Msg(); }
                    }

                    elementy.Sort();
                }
                public Pracownik Pracownik {
                    get { return pracownik; }
                }
                public PracHistoria Historia {
                    get { return historia; }
                }
                public IEnumerable Elementy {
                    get { return elementy; }
                }
                public bool Wchodzi {
                    get { return elementy.Count > 0; }
                }
                public int CompareTo(object obj) {
                    if (obj == null)
                        return 1;
                    Total t = obj as Total;
                    if (t == null)
                        throw new ArgumentException();
                    return pracownik.CompareTo(t.pracownik);
                }
            }

            public class PrnParams : Soneta.Business.ContextBase {
                public PrnParams(Context context)
                    : base(context) {
                    Date data = ((ActualDate)context[typeof(ActualDate)]).Actual;
                    okres = FromTo.Year(data.Year);
                }
                FromTo okres;
                [Required]
                public FromTo Okres {
                    get { return okres; }
                    set {
                        okres = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }
	
	        PrnParams pars;
            [Soneta.Business.Context(Required = true)]
            public PrnParams Params {
                get { return pars; }
                set { pars = value; }
            }
	
	        string nazwaOkresu;
		    
            void OnContextLoad(Object sender, EventArgs args) {
                report = ReportHeader1;
                if (pars.Okres == FromTo.Year(pars.Okres.From.Year))
                    nazwaOkresu = pars.Okres.From.Year + " rok";
                else
                    nazwaOkresu = "okres " + pars.Okres.ToString();

                Row[] rows = (Row[])dc[typeof(Row[])];
                ArrayList result = new ArrayList();
                foreach (Pracownik p in rows) {
                    Total t = new Total(p, pars.Okres);
                    if (t.Wchodzi)
                        result.Add(t);
                }
                DataRepeater1.DataSource = result;
            }

            //Dictionary<PrzyczynaNieobecnosci, int> narastająco;

            void OnBeforeRow(Object sender, EventArgs args) {
                //narastająco = new Dictionary<PrzyczynaNieobecnosci, int>();
                Total t = (Total)DataRepeater1.CurrentRow;
                Periods ps = Periods.Empty;
                foreach (PracHistoria ph in t.Pracownik.Historia)
                    ps += ph.Aktualnosc * ph.Etat.Ubezpieczenia.Chorobowe.Okres;
                ps = ps.ToFlat();
                FromTo ubezp = ps.Count == 0 ? FromTo.Empty : ps[ps.Count - 1];
                ReportHeader1.Title = string.Format("Karta zasiłkowa za {0}|{1}|</strong>Urodzony: <strong>{2}|</strong>PESEL: <strong>{3}|</strong>NIP: <strong>{4}|</strong>Adres: <strong>{5}|</strong>Zatrudniony - objęty ubezpieczeniem chorobowym od: <strong>{6}</strong>|Zwolniony - wyłączony z ubezp. dnia: <strong>{7}</strong>",
                    nazwaOkresu,
                    t.Pracownik.NazwiskoImię,
                    t.Historia.Urodzony.Data,
                    t.Historia.PESEL,
                    t.Historia.NIP,
                    t.Historia.Adres,
                    ubezp.From,
                    ubezp.To == Date.MaxValue ? ". . . . . . . . . ." : ubezp.To.ToString());

                prev = null;
                okresZas = 0;
                okresyZas.Clear();
            }

            List<FromTo> okresyZas = new List<FromTo>();
            WypElementNieobecność prev = null;
            int okresZas = 0;    
		        
            protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
                Total.Item item = (Total.Item)args.Row;
                WypElementNieobecność en = item.Element as WypElementNieobecność;
                Nieobecnosc n = null;
                if (en != null)
                    n = en.Nieobecność;

                if (n == null || n.Korygowana)
                    return;

                if (!okresyZas.Contains(item.Element.Okres))
                {
                    int dni = item.Dni;
                    if (prev != null && prev.Nieobecność.Definicja.Przyczyna == n.Definicja.Przyczyna && Kontynuacja(prev.Nieobecność, prev.Okres, n, en.Okres)) {
                            okresZas += dni;
                    }
                    else
                        okresZas = dni;

                    prev = en;
                    colDniNarast.EditValue = okresZas;
                    okresyZas.Add(item.Element.Okres);
                }
                    
            }

            bool Kontynuacja(Nieobecnosc prev, FromTo prevOkres, Nieobecnosc curr, FromTo currOkres) {
                if (prev.Definicja.Przyczyna == PrzyczynaNieobecnosci.ZwolnienieChorobowe ||
                    prev.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopRehabilitacyjny)
                    switch (curr.Zwolnienie.KontynuacjaOkrZas) {
                        case KontynuacjaOkrZas.Tak:
                            return currOkres.From - prevOkres.To - 1 <= 60;
                        case KontynuacjaOkrZas.Nie:
                            return false;
                    }
                return (prevOkres.To + 1 == currOkres.From);
            }
		    
            public static void Msg(object obj) {
            }

            public static ReportHeader report;

            public static void Msg() {
                string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
                if (report != null && !report.Title.Contains(msg))
                    report.Title += "|" + msg;
            }

</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="KartaZasiłkowa" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"
				Landscape="True"></ea:datacontext>
			<ea:datarepeater id="DataRepeater1" runat="server" onbeforerow="OnBeforeRow" Width="100%" Height="140px">
				<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
				<FONT face="Tahoma">
					<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Karta zasiłkowa" runat="server"></cc1:ReportHeader></FONT>
				<ea:Grid id="Grid1" runat="server" DataMember="Elementy" OnBeforeRow="Grid1_BeforeRow">
					<Columns>
						<ea:GridColumn Width="20" DataMember="Element.Wyplata.ListaPlac.Numer" Caption="Lista wypłat~Nr" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="10" DataMember="Element.Wyplata.Data" Caption="Lista wypłat~Data" NoWrap="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="6" Align="Center" DataMember="Element.Wyplata.Numer.Numer" Caption="Lista wypłat~Nr poz."
							NoWrap="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" DataMember="OkresOd" Caption="Okres niezdolności do pracy~od"
							NoWrap="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" DataMember="OkresDo" Caption="Okres niezdolności do pracy~do"
							NoWrap="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="6" Align="Center" DataMember="Dni" Caption="Okres niezdolności do pracy~dni"
							HideZero="True" NoWrap="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="ZasiłekDzn" Caption="Zasiłek dzienny" HideZero="True"
							Format="{0:n}" NoWrap="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="ZasiłekBrutto" Caption="Zasiłek (brutto)" HideZero="True"
							Format="{0:n}" NoWrap="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="ZalFIS" Caption="Przypis podatku" HideZero="True" Format="{0:n}"
							NoWrap="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Netto" Caption="Zasiłek (netto)" HideZero="True" Format="{0:n}"
							NoWrap="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="14" Align="Right" DataMember="Rodzaj" Caption="Rodz. i proc. zasiłku" NoWrap="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Center" DataMember="Symbol" Caption="Kod literowy" NoWrap="True" runat="server" Width="7"></ea:GridColumn>
						<ea:GridColumn runat="server" BgColor="" 
                            Caption="Wynagrodzenie lub przychód przyjęty do obliczenia zasiłku~za miesiące" 
                            CssClass="" FontColor="" FontFamily="" FontSize="" DataMember="Miesiące" 
                            Align="Center">
                        </ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Podstawa" 
                            Caption="Wynagrodzenie lub przychód przyjęty do obliczenia zasiłku~przeciętny" HideZero="True"
							Format="{0:n}" NoWrap="True" runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="colDniNarast" runat="server" Caption="Z okresu zasiłko-wego wypłac. za dni"
                            Width="8" Align="Center">
                        </ea:GridColumn>
					</Columns>
				</ea:Grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
			</ea:datarepeater>
		</form>
	</body>
</HTML>

